clc
clear all
close all
all_marks = {'o','+','*','.','x','s','d','^','v','>','<','p','h'};

set(0,'defaultTextInterpreter','latex'); %trying to set the default
set(0,'defaultAxesFontSize',20);
set(0,'defaultAxesFontName','TimesNewRoman');

P=1;
Test=2; %test
p_rel=3; %bar

Caricamento=['load P' num2str(P) '_' num2str(p_rel) 'bar_rel' '_' num2str(Test) '.txt'];
eval(Caricamento)
Capacitivo1=['x1_exp=P' num2str(P) '_' num2str(p_rel) 'bar_rel'  '_' num2str(Test) '(:,1);'];
Capacitivo2=['x2_exp=P' num2str(P) '_' num2str(p_rel) 'bar_rel'  '_' num2str(Test) '(:,2);'];
Capacitivo3=['x3_exp=P' num2str(P) '_' num2str(p_rel) 'bar_rel'  '_' num2str(Test) '(:,3);'];
Capacitivo4=['x4_exp=P' num2str(P) '_' num2str(p_rel) 'bar_rel'  '_' num2str(Test) '(:,4);'];
Forza=['F_exp=P' num2str(P) '_' num2str(p_rel) 'bar_rel' '_' num2str(Test) '(:,5);'];
Portata=['Q_exp=P' num2str(P) '_' num2str(p_rel) 'bar_rel' '_' num2str(Test) '(:,6);'];
eval(Capacitivo1)
eval(Capacitivo2)
eval(Capacitivo3)
eval(Capacitivo4)
eval(Forza)
eval(Portata)
m=1;
x1_exp=smooth(-x1_exp,m);
x2_exp=smooth(-x2_exp,m);
x3_exp=smooth(-x3_exp,m);
x4_exp=smooth(-x4_exp,m);
F_exp=smooth(F_exp,m);
Q_exp=smooth(Q_exp,m);
%Spostamento medio del pattino 
xm_exp=(x1_exp+x2_exp+x3_exp+x4_exp)/4;
%Definisco lo zero
[ind1s ind1s]=min(xm_exp);
x1_exp=x1_exp-x1_exp(ind1s);
x2_exp=x2_exp-x2_exp(ind1s);
x3_exp=x3_exp-x3_exp(ind1s);
x4_exp=x4_exp-x4_exp(ind1s);

%% Plot dati sperimentali grezzi
figure(1)
plot(x1_exp,F_exp,'b',x2_exp,F_exp,'r',x3_exp,F_exp,'g',x4_exp,F_exp,'k','linewidth',2,'MarkerSize',8),hold on
xlabel('Displacement $\quad x \: (\mu m)$'),ylabel('Force $ \quad F \: (N)$'), 
legend('$ x_1 $','$x_2$','$x_3$','$x_4$','interpreter','Latex')
grid on, zoom on
set(gca,'FontSize',32)


figure(2)
plot(x1_exp,Q_exp,'b',x2_exp,Q_exp,'r',x3_exp,Q_exp,'g',x4_exp,Q_exp,'k','linewidth',2,'MarkerSize',8), hold on
xlabel('Displacement $\quad x \: (\mu m)$'),ylabel('Flow Rate $ \quad Q \: (\frac{l}{min})$ ANR 20$^{\circ}$'), 
legend('$ x_1 $','$x_2$','$x_3$','$x_4$','interpreter','Latex')
grid on, zoom on
set(gca,'FontSize',32)
%%
xm_exp=(x1_exp+x2_exp+x3_exp+x4_exp)/4;
% Estrapolo le porzioni di curva per l'identificazione
[val ind]=max(F_exp);
inizio=100;
fine=100;
passo=25;
xm_exp=xm_exp(inizio:passo:ind-fine);
F_exp=F_exp(inizio:passo:ind-fine);
Q_exp=Q_exp(inizio:passo:ind-fine);
Ks_exp=-derivata(F_exp,xm_exp);

figure(1)
plot(xm_exp,F_exp,'y','linewidth',5,'MarkerSize',8), hold on
xlabel('Average displacement $\quad x \: (\mu m)$'),ylabel('Force $ \quad F \: (N)$'),
legend('$ x_1 $','$x_2$','$x_3$','$x_4$','Selection 1','interpreter','Latex')
grid on, zoom on

figure(2)
plot(xm_exp,Q_exp,'y','linewidth',5,'MarkerSize',8), hold on
xlabel('Displacement $\quad x \: (\mu m)$'),ylabel('Flow Rate $ \quad Q \: (\frac{l}{min})$ ANR 20$^{\circ}$'), 
legend('$ x_1 $','$x_2$','$x_3$','$x_4$','Selection 1','interpreter','Latex')
grid on, zoom on

figure(3)
plot(xm_exp,Ks_exp,'b','linewidth',5,'MarkerSize',8),hold on
xlabel('Average displacement $\quad x \: (\mu m)$'),ylabel('Stiffness $ \quad k_s \: (\frac{N}{\mu m})$'), 
grid on, zoom on
%%
%Riduco ancora il numero di campioni in base alla rigidezza trovata (se
%troppo alta potrei avere contatto metallo metallo)
h_min=2;
[val ind]=min(abs(xm_exp-h_min));
xm_exp=xm_exp(1:ind);
F_exp=F_exp(1:ind);
Q_exp=Q_exp(1:ind);
Ks_exp=Ks_exp(1:ind);

figure(1)
plot(xm_exp,F_exp,'m','linewidth',5,'MarkerSize',8),
xlabel('Average displacement $\quad x \: (\mu m)$'),ylabel('Force $ \quad F \: (N)$'),
legend('$ x_1 $','$x_2$','$x_3$','$x_4$','Selection 1','Final Selection','interpreter','Latex')
grid on, zoom on

figure(2)
plot(xm_exp,Q_exp,'m','linewidth',5,'MarkerSize',8),
xlabel('Displacement $\quad x \: (\mu m)$'),ylabel('Flow Rate $ \quad Q \: (\frac{l}{min})$ ANR 20$^{\circ}$'), 
legend('$ x_1 $','$x_2$','$x_3$','$x_4$','Selection 1','Final Selection','interpreter','Latex')
grid on, zoom on

figure(3)
plot(xm_exp,Ks_exp,'m','linewidth',5,'MarkerSize',8),hold on
xlabel('Average displacement $\quad x \: (\mu m)$'),ylabel('Stiffness $ \quad k_s \: (\frac{N}{\mu m})$'), 
grid on, zoom on

Meato=['h_ps' num2str(p_rel*100) '_' num2str(Test) '=xm_exp;'];
Portanza=['F_ps' num2str(p_rel*100) '_' num2str(Test) '=F_exp;'];
Portata=['Q_ps' num2str(p_rel*100) '_' num2str(Test) '=Q_exp;'];
Rigidezza=['Ks_ps' num2str(p_rel*100) '_' num2str(Test) '=Ks_exp;'];

eval(Meato)
eval(Portanza)
eval(Portata)
eval(Rigidezza)

Salvataggio=['save P' num2str(P) '_' num2str(p_rel) 'bar_rel' '_' num2str(Test) ...
             ' h_ps' num2str(p_rel*100) '_' num2str(Test) ...
             ' F_ps' num2str(p_rel*100) '_' num2str(Test) ...
             ' Q_ps' num2str(p_rel*100) '_' num2str(Test) ...
             ' Ks_ps' num2str(p_rel*100) '_' num2str(Test)];
        
         eval(Salvataggio)
         
